/***************************************************************************
 *   Copyright (C) 2007 by Matthew Rosewarne   *
 *   mukidohime@case.edu   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ncurses.h>

void create_box(int y, int x, int w, int h)
{
	mvaddch(y, x, '+');
	mvaddch(y, x + w, '+');
	mvaddch(y + h, x, '+');
	mvaddch(y + h, x + w, '+');
	mvhline(y, x + 1, '-', w - 1);
	mvhline(y + h, x + 1, '-', w - 1);
	mvvline(y + 1, x, '|', h - 1);
	mvvline(y + 1, x + w, '|', h - 1);
}

int main()
{
	int startx, starty, height, width;
	
	initscr();
	start_color();
	cbreak();
	keypad(stdscr, TRUE);
	noecho();

	init_pair(1, COLOR_BLACK, COLOR_CYAN);
	
	height = 2;
	width = 30;
	starty = (LINES - height)/2;
	startx = (COLS - width)/2;

	attron(COLOR_PAIR(1));
	
	create_box(starty, startx, width, height);
	mvprintw(starty, startx + 3, " Hello World! " );
	mvprintw(starty+1,startx+1," Type any char to exit       ");
	mvprintw(0,0,"");
	refresh();
	getch();
	
	endwin();
	return 0;
}
